#include <jim.h>
int Jim_tclcompatInit(Jim_Interp *interp)
{
	if (Jim_PackageProvide(interp, "tclcompat", "1.0", JIM_ERRMSG))
		return JIM_ERR;

	return Jim_Eval_Named(interp, 
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"set env [env]\n"
"\n"
"\n"
"foreach p {gets flush close eof seek tell} {\n"
"	proc $p {chan args} {p} {\n"
"		tailcall $chan $p {*}$args\n"
"	}\n"
"}\n"
"unset p\n"
"\n"
"\n"
"\n"
"proc puts {{-nonewline {}} {chan stdout} msg} {\n"
"	if {${-nonewline} ni {-nonewline {}}} {\n"
"		tailcall ${-nonewline} puts $msg\n"
"	}\n"
"	tailcall $chan puts {*}${-nonewline} $msg\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc read {{-nonewline {}} chan} {\n"
"	if {${-nonewline} ni {-nonewline {}}} {\n"
"		tailcall ${-nonewline} read {*}${chan}\n"
"	}\n"
"	tailcall $chan read {*}${-nonewline}\n"
"}\n"
"\n"
"\n"
"\n"
"proc case {var args} {\n"
"\n"
"	if {[lindex $args 0] eq \"in\"} {\n"
"		set args [lrange $args 1 end]\n"
"	}\n"
"\n"
"\n"
"	if {[llength $args] == 1} {\n"
"		set args [lindex $args 0]\n"
"	}\n"
"\n"
"\n"
"	if {[llength $args] % 2 != 0} {\n"
"		return -code error \"extra case pattern with no body\"\n"
"	}\n"
"\n"
"\n"
"	local proc case.checker {value pattern} {\n"
"		string match $pattern $value\n"
"	}\n"
"\n"
"	foreach {value action} $args {\n"
"		if {$value eq \"default\"} {\n"
"			set do_action $action\n"
"			continue\n"
"		} elseif {[lsearch -bool -command case.checker $value $var]} {\n"
"			set do_action $action\n"
"			break\n"
"		}\n"
"	}\n"
"\n"
"	if {[info exists do_action]} {\n"
"		set rc [catch [list uplevel 1 $do_action] result opts]\n"
"		if {$rc} {\n"
"			incr opts(-level)\n"
"		}\n"
"		return {*}$opts $result\n"
"	}\n"
"}\n"
"\n"
"\n"
"proc fileevent {args} {\n"
"	tailcall {*}$args\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"proc parray {arrayname {pattern *} {puts puts}} {\n"
"	upvar $arrayname a\n"
"\n"
"	set max 0\n"
"	foreach name [array names a $pattern]] {\n"
"		if {[string length $name] > $max} {\n"
"			set max [string length $name]\n"
"		}\n"
"	}\n"
"	incr max [string length $arrayname]\n"
"	incr max 2\n"
"	foreach name [lsort [array names a $pattern]] {\n"
"		$puts [format \"%-${max}s = %s\" $arrayname\\($name\\) $a($name)]\n"
"	}\n"
"}\n"
"\n"
"\n"
"proc {file copy} {{force {}} source target} {\n"
"	try {\n"
"		if {$force ni {{} -force}} {\n"
"			error \"bad option \\\"$force\\\": should be -force\"\n"
"		}\n"
"\n"
"		set in [open $source]\n"
"\n"
"		if {$force eq \"\" && [file exists $target]} {\n"
"			$in close\n"
"			error \"error copying \\\"$source\\\" to \\\"$target\\\": file already exists\"\n"
"		}\n"
"		set out [open $target w]\n"
"		$in copyto $out\n"
"		$out close\n"
"	} on error {msg opts} {\n"
"		incr opts(-level)\n"
"		return {*}$opts $msg\n"
"	} finally {\n"
"		catch {$in close}\n"
"	}\n"
"}\n"
"\n"
"\n"
"\n"
"proc popen {cmd {mode r}} {\n"
"	lassign [socket pipe] r w\n"
"	try {\n"
"		if {[string match \"w*\" $mode]} {\n"
"			lappend cmd <@$r &\n"
"			set pids [exec {*}$cmd]\n"
"			$r close\n"
"			set f $w\n"
"		} else {\n"
"			lappend cmd >@$w &\n"
"			set pids [exec {*}$cmd]\n"
"			$w close\n"
"			set f $r\n"
"		}\n"
"		lambda {cmd args} {f pids} {\n"
"			if {$cmd eq \"pid\"} {\n"
"				return $pids\n"
"			}\n"
"			tailcall $f $cmd {*}$args\n"
"		}\n"
"	} on error {error opts} {\n"
"		$r close\n"
"		$w close\n"
"		error $error\n"
"	}\n"
"}\n"
"\n"
"\n"
"if {[info commands pid] ne \"\"} {\n"
"rename pid .pid\n"
"proc pid {{chan {}}} {\n"
"	if {$chan eq \"\"} {\n"
"		tailcall .pid\n"
"	}\n"
"	if {[catch {$chan tell}} {\n"
"		return -code error \"can not find channel named \\\"$chan\\\"\"\n"
"	}\n"
"	if {[catch {$chan pid} pids} {\n"
"		return \"\"\n"
"	}\n"
"	return $pids\n"
"}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc try {args} {\n"
"	set catchopts {}\n"
"	while {[string match -* [lindex $args 0]]} {\n"
"		set args [lassign $args opt]\n"
"		if {$opt eq \"--\"} {\n"
"			break\n"
"		}\n"
"		lappend catchopts $opt\n"
"	}\n"
"	if {[llength $args] == 0} {\n"
"		return -code error {wrong # args: should be \"try ?options? script ?argument ...?\"}\n"
"	}\n"
"	set args [lassign $args script]\n"
"	set code [catch -eval {*}$catchopts [list uplevel 1 $script] msg opts]\n"
"\n"
"	set handled 0\n"
"\n"
"	foreach {on codes vars script} $args {\n"
"		switch -- $on \\\n"
"			on {\n"
"				if {!$handled && ($codes eq \"*\" || [info returncode $code] in $codes)} {\n"
"					lassign $vars msgvar optsvar\n"
"					if {$msgvar ne \"\"} {\n"
"						upvar $msgvar hmsg\n"
"						set hmsg $msg\n"
"					}\n"
"					if {$optsvar ne \"\"} {\n"
"						upvar $optsvar hopts\n"
"						set hopts $opts\n"
"					}\n"
"\n"
"					set code [catch [list uplevel 1 $script] msg opts]\n"
"					incr handled\n"
"				}\n"
"			} \\\n"
"			finally {\n"
"				set finalcode [catch [list uplevel 1 $codes] finalmsg finalopts]\n"
"				if {$finalcode} {\n"
"\n"
"					set code $finalcode\n"
"					set msg $finalmsg\n"
"					set opts $finalopts\n"
"				}\n"
"				break\n"
"			} \\\n"
"			default {\n"
"				return -code error \"try: expected 'on' or 'finally', got '$on'\"\n"
"			}\n"
"	}\n"
"\n"
"	if {$code} {\n"
"		incr opts(-level)\n"
"		return {*}$opts $msg\n"
"	}\n"
"	return $msg\n"
"}\n"
"\n"
"\n"
"\n"
"proc throw {code {msg \"\"}} {\n"
"	return -code $code $msg\n"
"}\n"
,"tclcompat.tcl", 1);
}
