#include <jim.h>
int Jim_stdlibInit(Jim_Interp *interp)
{
	if (Jim_PackageProvide(interp, "stdlib", "1.0", JIM_ERRMSG))
		return JIM_ERR;

	return Jim_Eval_Named(interp, 
"\n"
"\n"
"\n"
"proc alias {name args} {\n"
"	set prefix $args\n"
"	proc $name args prefix {\n"
"		tailcall {*}$prefix {*}$args\n"
"	}\n"
"}\n"
"\n"
"\n"
"proc lambda {arglist args} {\n"
"	set name [ref {} function lambda.finalizer]\n"
"	tailcall proc $name $arglist {*}$args\n"
"}\n"
"\n"
"proc lambda.finalizer {name val} {\n"
"	rename $name {}\n"
"}\n"
"\n"
"\n"
"proc curry {args} {\n"
"	set prefix $args\n"
"	lambda args prefix {\n"
"		tailcall {*}$prefix {*}$args\n"
"	}\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc function {value} {\n"
"	return $value\n"
"}\n"
"\n"
"\n"
"proc lassign {list args} {\n"
"\n"
"	lappend list {}\n"
"	uplevel 1 [list foreach $args $list break]\n"
"	lrange $list [llength $args] end-1\n"
"}\n"
"\n"
"\n"
"\n"
"\n"
"proc stacktrace {} {\n"
"	set trace {}\n"
"	foreach level [range 1 [info level]] {\n"
"		lassign [info frame -$level] p f l\n"
"		lappend trace $p $f $l\n"
"	}\n"
"	return $trace\n"
"}\n"
"\n"
"\n"
"proc stackdump {stacktrace} {\n"
"	set result {}\n"
"	set count 0\n"
"	foreach {l f p} [lreverse $stacktrace] {\n"
"		if {$count} {\n"
"			append result \\n\n"
"		}\n"
"		incr count\n"
"		if {$p ne \"\"} {\n"
"			append result \"in procedure '$p' \"\n"
"			if {$f ne \"\"} {\n"
"				append result \"called \"\n"
"			}\n"
"		}\n"
"		if {$f ne \"\"} {\n"
"			append result \"at file \\\"$f\\\", line $l\"\n"
"		}\n"
"	}\n"
"	return $result\n"
"}\n"
"\n"
"\n"
"\n"
"proc errorInfo {msg {stacktrace \"\"}} {\n"
"	if {$stacktrace eq \"\"} {\n"
"		set stacktrace [info stacktrace]\n"
"	}\n"
"	lassign $stacktrace p f l\n"
"	if {$f ne \"\"} {\n"
"		set result \"Runtime Error: $f:$l: \"\n"
"	}\n"
"	append result \"$msg\\n\"\n"
"	append result [stackdump $stacktrace]\n"
"\n"
"\n"
"	string trim $result\n"
"}\n"
"\n"
"\n"
"\n"
"proc {info nameofexecutable} {} {\n"
"	if {[info exists ::jim_argv0]} {\n"
"		if {[string first \"/\" $::jim_argv0] >= 0} {\n"
"			return $::jim_argv0\n"
"		}\n"
"		foreach path [split [env PATH \"\"] :] {\n"
"			set exec [file join $path $::jim_argv0]\n"
"			if {[file executable $exec]} {\n"
"				return $exec\n"
"			}\n"
"		}\n"
"	}\n"
"	return \"\"\n"
"}\n"
"\n"
"\n"
"proc {dict with} {dictVar args script} {\n"
"	upvar $dictVar dict\n"
"	set keys {}\n"
"	foreach {n v} [dict get $dict {*}$args] {\n"
"		upvar $n var_$n\n"
"		set var_$n $v\n"
"		lappend keys $n\n"
"	}\n"
"	catch {uplevel 1 $script} msg opts\n"
"	if {[info exists dict] && [dict exists $dict {*}$args]} {\n"
"		foreach n $keys {\n"
"			if {[info exists var_$n]} {\n"
"				dict set dict {*}$args $n [set var_$n]\n"
"			} else {\n"
"				dict unset dict {*}$args $n\n"
"			}\n"
"		}\n"
"	}\n"
"	return {*}$opts $msg\n"
"}\n"
"\n"
"\n"
"\n"
"proc {dict merge} {dict args} {\n"
"	foreach d $args {\n"
"\n"
"		dict size $d\n"
"		foreach {k v} $d {\n"
"			dict set dict $k $v\n"
"		}\n"
"	}\n"
"	return $dict\n"
"}\n"
,"stdlib.tcl", 1);
}
