#include <jim.h>
int Jim_globInit(Jim_Interp *interp)
{
	if (Jim_PackageProvide(interp, "glob", "1.0", JIM_ERRMSG))
		return JIM_ERR;

	return Jim_Eval_Named(interp, 
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"package require readdir\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"\n"
"proc glob {args} {\n"
"\n"
"\n"
"\n"
"\n"
"	local proc glob.readdir_pattern {dir pattern} {\n"
"		set result {}\n"
"\n"
"\n"
"		if {$pattern in {. ..}} {\n"
"			return $pattern\n"
"		}\n"
"\n"
"\n"
"		foreach name [readdir -nocomplain $dir] {\n"
"			if {[string match $pattern $name]} {\n"
"\n"
"				if {[string index $name 0] eq \".\" && [string index $pattern 0] ne \".\"} {\n"
"					continue\n"
"				}\n"
"				lappend result $name\n"
"			}\n"
"		}\n"
"\n"
"		return $result\n"
"	}\n"
"\n"
"\n"
"\n"
"	local proc glob.do {dir rem} {\n"
"\n"
"\n"
"		set i [string first / $rem]\n"
"		if {$i < 0} {\n"
"			set pattern $rem\n"
"			set rempattern \"\"\n"
"		} else {\n"
"			set pattern [string range $rem 0 $i-1]\n"
"			set rempattern [string range $rem $i+1 end]\n"
"		}\n"
"\n"
"\n"
"		set sep /\n"
"		set globdir $dir\n"
"		if {[string match \"*/\" $dir]} {\n"
"			set sep \"\"\n"
"		} elseif {$dir eq \"\"} {\n"
"			set globdir .\n"
"			set sep \"\"\n"
"		}\n"
"\n"
"		set result {}\n"
"\n"
"\n"
"\n"
"\n"
"		if {[set fb [string first \"\\{\" $pattern]] >= 0} {\n"
"			if {[set nb [string first \"\\}\" $pattern $fb]] >= 0} {\n"
"				set before [string range $pattern 0 $fb-1]\n"
"				set braced [string range $pattern $fb+1 $nb-1]\n"
"				set after [string range $pattern $nb+1 end]\n"
"\n"
"				foreach part [split $braced ,] {\n"
"					lappend result {*}[glob.do $dir $before$part$after]\n"
"				}\n"
"				return $result\n"
"			}\n"
"		}\n"
"\n"
"\n"
"		foreach f [glob.readdir_pattern $globdir $pattern] {\n"
"			if {$rempattern eq \"\"} {\n"
"\n"
"				lappend result $dir$sep$f\n"
"			} else {\n"
"\n"
"				lappend result {*}[glob.do $dir$sep$f $rempattern]\n"
"			}\n"
"		}\n"
"		return $result\n"
"	}\n"
"\n"
"\n"
"	set nocomplain 0\n"
"\n"
"	if {[lindex $args 0] eq \"-nocomplain\"} {\n"
"		set nocomplain 1\n"
"		set args [lrange $args 1 end]\n"
"	}\n"
"\n"
"	set result {}\n"
"	foreach pattern $args {\n"
"		if {$pattern eq \"/\"} {\n"
"			lappend result /\n"
"		} elseif {[string match \"/*\" $pattern]} {\n"
"			lappend result {*}[glob.do / [string range $pattern 1 end]]\n"
"		} else {\n"
"			lappend result {*}[glob.do \"\" $pattern]\n"
"		}\n"
"	}\n"
"\n"
"	if {$nocomplain == 0 && [llength $result] == 0} {\n"
"		return -code error \"no files matched glob patterns\"\n"
"	}\n"
"\n"
"	return $result\n"
"}\n"
,"glob.tcl", 1);
}
