#!/usr/bin/perl
# Automatically generates the StellarisParts struct in src/flash/nor/stellaris.c
# Uses the header files from TI/Luminary's StellarisWare complete Firmware Development Package
# available from: http://www.luminarymicro.com/products/software_updates.html

$comment = "// Autogenerated by contrib/gen-stellaris-part-header.pl
// From Stellaris Firmware Development Package revision";

$struct_header = "static struct {
	uint32_t partno;
	const char *partname;
}	StellarisParts[] =
{
";

$struct_footer = "\t{0,\"Unknown part\"}\n};\n";

$#ARGV == 1 || die "Usage: $0 <inc directory> <output file>\n";
-d $ARGV[0] || die $ARGV[0]." is not a directory\n";
$dir = $ARGV[0];
-f $ARGV[1] || die $ARGV[1]." is not a file\n";
$file = $ARGV[1];
print STDERR "Scanning $dir, Updating $file\n";

opendir(DIR, $dir) || die "can't open $dir: $!";
@files = readdir(DIR);
closedir(DIR);

@short_files = sort(grep(/lm3s...\.h/, @files));
@long_files = sort(grep(/lm3s....\.h/, @files));

$ver = 0;
$new_struct = $struct_header;
process_file(@short_files);
process_file(@long_files);
$new_struct .= $struct_footer;

$dump = "$comment $ver\n$new_struct";
{
	local($/, *INPUT);
	open(INPUT, $file) || die "can't open $file: $!";
	$contents = <INPUT>;
	close(INPUT);
}

$old_struct = qr/((^\/\/.*?\n)*)\Q$struct_header\E.*?$struct_footer/sm;
$contents =~ s/$old_struct/$dump/;
open(OUTPUT, ">$file") || die "can't open file $file for writing: $!";
print OUTPUT $contents;
close(OUTPUT);

sub process_file {
	foreach $h_file (@_) {
		($base) = ($h_file =~ m/lm3s(.{3,4})\.h/ig);
		$base = uc($base);
		local($/, *FILE);
		open(FILE, "$dir/$h_file");
		$content = <FILE>;
		close(FILE);
		$invalid = 0;
		if ($content =~ /This is part of revision (\d+) of/) {
			if ($ver != 0 and $ver != $1) {
				print STDERR "File version mismatch: $ver != $1\n";
				$ver = max($ver, $1);
			} else {
				$ver = $1;
			}
		}
		if ($content =~ /SYSCTL_DID1_VER_[^M]\s+0x(\S+)/) {
			$did1_ver = hex($1);
		} else {
			print STDERR "$h_file is missing SYSCTL_DID1_VER\n";
			$did1_ver = 255;
			$invalid = 1;
		}
		if ($content =~ /SYSCTL_DID1_PRTNO_$base\s+0x(\S+)/) {
			$prtno = hex($1);
		} else {
			print STDERR "$h_file is missing SYSCTL_DID1_PRTNO\n";
			$prtno = 0;
			$invalid = 1;
		}
		$id = ($did1_ver | $prtno) >> 16;
		$new_member = sprintf "{0x%04X,\"LM3S%s\"},", $id, $base;
		if ($invalid == 1) {
			#$new_struct .= "\t//$new_member\t// Invalid\n";
		} else {
			$new_struct .= "\t$new_member\n";
		}
	}
}
